function EnemySystem(){

	this.danger=0; //increases every step on map
	this.danger_increase_rate = 1;
	
	
	this.max_enemies=5;
	this.max_set_size=4;
	
	this.possible_enemies = [];
	this.enemies=[]; //array of all enemies on map
	
	this.update_counter = 10;

	this.update_rate = 100;
	
	this.aim_x=0;
	this.aim_y=0;
	
	this.party_sprite = undefined;
	this.tirevalue=1;
	this.pause = false;
}

EnemySystem.prototype.clear = function(){
	with(this){
		
		delete possible_enemies;
		possible_enemies =[];
		for(var i=0;i<enemies.length;i++)
			if(enemies[i]!=undefined)
				enemies[i].destroy();
		
		enemies=[];
		max_enemies=5;
		max_set_size=4;		
		danger = 0;
		danger_increase_rate = 5;
		aim_x=0;
		aim_y=0;
		update_counter = 10;
		update_rate = 100;
		party_sprite = undefined;
		fight_name = "";
		pause = false;
		}
	
}

EnemySystem.prototype.setPartySprite = function(name){
	with(this){
	
		party_sprite = name;
	
	}
}

EnemySystem.prototype.update = function(){
	with(this){
		if(pause)return;
		if(party_sprite!=undefined){
			fight_name="";
			if(GetObstructingPerson(party_sprite, GetPersonX(party_sprite)+1,GetPersonY(party_sprite))!=""){
				fight_name=GetObstructingPerson(party_sprite, GetPersonX(party_sprite)+1,GetPersonY(party_sprite));
				}
			else if(GetObstructingPerson(party_sprite, GetPersonX(party_sprite)-1,GetPersonY(party_sprite))!=""){
				fight_name=GetObstructingPerson(party_sprite, GetPersonX(party_sprite)-1,GetPersonY(party_sprite));
				}
			else if(GetObstructingPerson(party_sprite, GetPersonX(party_sprite),GetPersonY(party_sprite)+1)!=""){
				fight_name=GetObstructingPerson(party_sprite, GetPersonX(party_sprite),GetPersonY(party_sprite)+1);
				}
			else if(GetObstructingPerson(party_sprite, GetPersonX(party_sprite),GetPersonY(party_sprite)-1)!=""){
				fight_name=GetObstructingPerson(party_sprite, GetPersonX(party_sprite),GetPersonY(party_sprite)-1);
				}
			if(fight_name!="")checkFight(fight_name);
			}
		
		if(!(update_counter-->0)){
		
			if(danger<100)danger+=danger_increase_rate;
			if(danger>100)danger=100;
			
			if(party_sprite!=undefined){
				aim_x=GetPersonX(party_sprite);
				aim_y=GetPersonY(party_sprite);
				}
			
			updateEnemies();
						
			update_counter=update_rate;
			}
		
		}

}


EnemySystem.prototype.updateEnemies = function(){
	with(this){
		
		
		for(var i=0;i<max_enemies;i++){
			if(enemies[i]==undefined){
				enemies[i]=createNewEnemy(i);
				
				break;
				}
			}
					
		for(var i=0;i<enemies.length;i++){
			if(enemies[i]==undefined)continue;
			
			if(Math.abs(GetPersonX(enemies[i].name)-aim_x)>GetScreenWidth()/2||Math.abs(GetPersonY(enemies[i].name)-aim_y)>GetScreenHeight()/2)
				enemies[i].agression-=danger_increase_rate;
			
						
			
			var h_fields = [];
			var m_fields = [];
			var c_fields = [];
			
			if(aim_x/GetTileWidth()==GetPersonX(enemies[i].name)/GetTileWidth()){
				m_fields.push([GetPersonX(enemies[i].name)+GetTileWidth(),GetPersonY(enemies[i].name)]);
				m_fields.push([GetPersonX(enemies[i].name)-GetTileWidth(),GetPersonY(enemies[i].name)]);
				if(aim_y/GetTileHeight()==GetPersonY(enemies[i].name)/GetTileHeight()){
					
					m_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)+GetTileHeight()]);
					m_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)-GetTileHeight()]);
					c_fields=h_fields=m_fields;
					}
				else{
					
					if(aim_y/GetTileHeight()>GetPersonY(enemies[i].name)/GetTileHeight()){
						
						h_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)+GetTileHeight()]);
						c_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)-GetTileHeight()]);
						
						}
					else{
						
						c_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)+GetTileHeight()]);
						h_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)-GetTileHeight()]);
						
						}
					}
				}
			else{
				if(aim_x/GetTileWidth()>GetPersonX(enemies[i].name)/GetTileWidth()){
					
					h_fields.push([GetPersonX(enemies[i].name)+GetTileWidth(),GetPersonY(enemies[i].name)]);
					c_fields.push([GetPersonX(enemies[i].name)-GetTileWidth(),GetPersonY(enemies[i].name)]);
					
					if(aim_y/GetTileHeight()==GetPersonY(enemies[i].name)/GetTileHeight()){
						
						m_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)+GetTileHeight()]);
						m_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)-GetTileHeight()]);
						
						}
					else{
						
						if(aim_y/GetTileHeight()>GetPersonY(enemies[i].name)/GetTileHeight()){
							
							h_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)+GetTileHeight()]);
							c_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)-GetTileHeight()]);
							m_fields=c_fields;
							m_fields=m_fields.concat(h_fields);
							}
						else{
							
							c_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)+GetTileHeight()]);
							h_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)-GetTileHeight()]);
							m_fields=c_fields;
							m_fields=m_fields.concat(h_fields);
							}
						}
					
					
					}
				else{
					
					c_fields.push([GetPersonX(enemies[i].name)+GetTileWidth(),GetPersonY(enemies[i].name)]);
					h_fields.push([GetPersonX(enemies[i].name)-GetTileWidth(),GetPersonY(enemies[i].name)]);
					
					if(aim_y/GetTileHeight()==GetPersonY(enemies[i].name)/GetTileHeight()){
						
						m_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)+GetTileHeight()]);
						m_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)-GetTileHeight()]);
						
						}
					else{
						if(aim_y/GetTileHeight()>GetPersonY(enemies[i].name)/GetTileHeight()){
							
							h_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)+GetTileHeight()]);
							c_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)-GetTileHeight()]);
							m_fields=c_fields;
							m_fields=m_fields.concat(h_fields);
							}
						else{
							
							c_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)+GetTileHeight()]);
							h_fields.push([GetPersonX(enemies[i].name),GetPersonY(enemies[i].name)-GetTileHeight()]);
							m_fields=c_fields;
							m_fields=m_fields.concat(h_fields);
							}
						}
					}
				}
			
			var field = undefined;
			
			/*DEBUG*
			GetSystemFont().drawText(100,100+i*20,c_fields.length+","+m_fields.length+","+h_fields.length);
			FlipScreen();
			GetKey();
			/**/
			
			if(enemies[i].agression<30){
				field = c_fields[Math.floor(Math.min(Math.random(),0.99)*c_fields.length)];
				}
			else if(enemies[i].agression<60){
				field = m_fields[Math.floor(Math.min(Math.random(),0.99)*m_fields.length)];
				
				}
			else if(enemies[i].agression>=60){
				field = h_fields[Math.floor(Math.min(Math.random(),0.99)*h_fields.length)];
				
				}
		
			
			var nx=GetPersonX(enemies[i].name);
			var ny=GetPersonY(enemies[i].name);
			
			
			
				
			
			while(nx!=field[0]){
				if(nx>field[0]){
					nx--;
					enemies[i].movevec[0]--;
					}
				else if(nx<field[0]){
					nx++;
					enemies[i].movevec[0]++;
					}
				}
			while(ny!=field[1]){
				if(ny>field[1]){
					ny--;
					enemies[i].movevec[1]--;
					}
				else if(ny<field[1]){
					ny++;
					enemies[i].movevec[1]++;
					}
				}
			
			/*DEBUG
				font.drawText(100,100,"agression:"+enemies[i].agression+" danger:"+danger);
				FlipScreen();
				GetKey();
				/**/
			
			if(enemies[i].agression<=0){
				enemies[i].destroySprite();
				delete enemies[i];
				}
			
			
			}
		}
}


EnemySystem.prototype.createNewEnemy = function(index){
	with(this){
	
		var counter = 0;
		var random = 0;
		var agr = 0;
		
		es = new EnemySet(index);
		es.lock_for_battle=10;
		while(counter<Math.min(4,max_set_size)){
			
			for(var i=0;i<possible_enemies.length;i++){
				random = Math.random()*100;
				
				if(random<possible_enemies[i][2]&&danger>possible_enemies[i][1]&&danger/2<possible_enemies[i][1]){
					es.sources.push(possible_enemies[i][0]);
					agr+=possible_enemies[i][1];
					danger-=es.sources.length*tirevalue;
					break;
					}
				}
			counter++	
			}
			
		if(es.sources.length>0){
			
			//danger/=2;
			//danger-=es.sources.length*5;
			es.agression = agr/es.sources.length;
			
			
			var gotTile= false;
			var gx=0;
			var gy=0;
			
			switch(GetPersonDirection(party_sprite)){
				
				case "north":
					gx=GetPersonX(party_sprite);
					gy=GetPersonY(party_sprite)-GetScreenHeight()/2;
					break;
				case "northeast":
					gx=GetPersonX(party_sprite)+GetScreenWidth()/2;
					gy=GetPersonY(party_sprite)-GetScreenHeight()/2;
					break;
				case "east":
					gx=GetPersonX(party_sprite)+GetScreenWidth()/2;
					gy=GetPersonY(party_sprite);
					break;
				case "southeast":
					gx=GetPersonX(party_sprite)+GetScreenWidth()/2;
					gy=GetPersonY(party_sprite)+GetScreenHeight()/2;
					break;
				case "south":
					gx=GetPersonX(party_sprite);
					gy=GetPersonY(party_sprite)+GetScreenHeight()/2;
					break;
				case "southwest":
					gx=GetPersonX(party_sprite)-GetScreenWidth()/2;
					gy=GetPersonY(party_sprite)+GetScreenHeight()/2;
					break;
				case "west":
					gx=GetPersonX(party_sprite)-GetScreenWidth()/2;
					gy=GetPersonY(party_sprite);
					break;
				case "northwest":
					gx=GetPersonX(party_sprite)-GetScreenWidth()/2;
					gy=GetPersonY(party_sprite)-GetScreenHeight()/2;
					break;
				
				}
			
			var dm=1;
			var dx=0;
			var dy=1;
			var xa=1;
			var ya=1;
			
			var ax=gx;
			var ay=gy;
			
			while(!gotTile){
				if(gx<0)gx=10;
				if(gy<0)gy=10;
				if(gx>=GetLayerWidth(GetPersonLayer(party_sprite))*32)gx=GetLayerWidth(GetPersonLayer(party_sprite))*32-10;
				if(gy>=GetLayerHeight(GetPersonLayer(party_sprite))*32)gy=GetLayerHeight(GetPersonLayer(party_sprite))*32-10;
				
				es.setPosition(gx,gy,GetPersonLayer(party_sprite));				
			/*DEBUG*
			//AttachCamera(es.name);
			UpdateMapEngine();
			RenderMap();
			GetSystemFont().drawText(100,100,es.name);
			FlipScreen();
			
			GetKey();
				/**/
								
				if(!IsPersonObstructed(es.name,gx,gy))gotTile=true;
				else{

					gx=ax+dx*32;
					gy=ay+dy*32;
					dx+=xa;
					if(Math.abs(dx)>=dm)xa*=-1;
					
					dy+=ya;	
					if(Math.abs(dy)>=dm)ya*=-1;
					
					if(dx==dm){
						dm++;
						dy=0;
						}
					}
					if(dm>=5){
						es.destroySprite();
						es.destroy();
						delete es;
						return undefined;
					}
			
				}
			es.setPosition(gx,gy,GetPersonLayer(party_sprite));
			
			return es;
			
			}
		else{
			es.destroySprite();
			es.destroy();
			delete es;
			}
			
		}
	return undefined;
}

EnemySystem.prototype.addPossibleEnemy = function(source,agression,chance_to_appear){
	with(this){
		
		possible_enemies.push([source,agression,chance_to_appear]);
	
	}
}

EnemySystem.prototype.checkFight = function(name){
	with(this){
		
		for(var i=0;i<enemies.length;i++){
			if(enemies[i]==undefined)continue;
			if(enemies[i].name==name){
				if(enemies[i].lock_for_battle>0){
					enemies[i].lock_for_battle--;
					return;
					}
				k_ResetKampfData();
				g_kdata.DontStopBgm=false;
				g_kdata.flucht=true;
				for(var k=0;k<enemies[i].sources.length;k++){
					g_kdata.gegner.push(CloneGeg(objectsystem.enems.get(enemies[i].sources[k])));
					}
				
				//RenderMap();
				enemies[i].lock_for_battle=100;
				if(TKampf()){
					enemies[i].lock_for_battle=100;
					enemies[i].destroySprite();
					delete enemies[i];
					for(var j=0;j<enemies.length;j++){
						if(enemies[j]!=undefined)enemies[j].agression/=2;
						}
					danger/=2;
					}
				else{
					enemies[i].lock_for_battle=100;
				}
				return;
				}
			}
	
	}
}
//*******************************************************************

function EnemySet(index){

	this.sources = [];
	this.agression = 0;
	this.map_position_x=0;
	this.map_position_y=0;
	this.aim_x=0;
	this.aim_y=0;
	this.created=false;
	this.name="map_enemy_"+index;	
	this.lock_for_battle=0;
	this.myMovement = undefined;
	this.movevec=[0,0];
	
}

EnemySet.prototype.setPosition = function(x,y,l){

		
		if(!this.created){
			CreatePerson(this.name,objectsystem.enems.get(this.sources[0]).spriteset ,true);
			
			SetPersonScript(this.name,SCRIPT_COMMAND_GENERATOR,"SetPersonMask( GetCurrentPerson(), CreateColor(255, 255, 255, Math.min(255, GetPersonMask(GetCurrentPerson()).alpha+10 ) ) ); if(GetPersonMask(GetCurrentPerson()).alpha>=255)SetPersonScript(GetCurrentPerson(),SCRIPT_COMMAND_GENERATOR,\"\");" );
			
			SetPersonSpeed(this.name,1+(Math.abs(this.agression-50)/50*1.5));
			SetPersonMask(this.name,CreateColor(255,255,255,0))
			this.created=true;
			this.myMovement = createTriggeredMovement(this.name,this.movevec,1);
			personcontroller.addInputProfile(this.name+"_movement",this.myMovement);
			}
		SetPersonX(this.name,x);
		SetPersonY(this.name,y);
		SetPersonLayer(this.name,l);
		
}

EnemySet.prototype.destroySprite = function(){
	if(!this.created)return;
	personcontroller.delInputProfile(this.name+"_movement");
	this.created=false;
	SetPersonScript(this.name,SCRIPT_COMMAND_GENERATOR,"SetPersonMask( GetCurrentPerson(), CreateColor(255, 255, 255, Math.max(0, GetPersonMask(GetCurrentPerson()).alpha-10 ) ) ); if(GetPersonMask(GetCurrentPerson()).alpha<=0)DestroyPerson(GetCurrentPerson());" );

}

EnemySet.prototype.destroy = function(){
	if(!this.created)return;
	personcontroller.delInputProfile(this.name+"_movement");
	this.created=false;
}

